unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, DBGrids, Db, DBTables, BDE, DBCtrls;

type
  TForm1 = class(TForm)
    Table1: TTable;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    CheckBox1: TCheckBox;
    Table1SYMBOL: TStringField;
    Table1CO_NAME: TStringField;
    Table1EXCHANGE: TStringField;
    Table1CUR_PRICE: TFloatField;
    Table1YRL_HIGH: TFloatField;
    Table1YRL_LOW: TFloatField;
    Table1P_E_RATIO: TFloatField;
    Table1BETA: TFloatField;
    Table1PROJ_GRTH: TFloatField;
    Table1INDUSTRY: TSmallintField;
    Table1PRICE_CHG: TSmallintField;
    Table1SAFETY: TSmallintField;
    Table1RATING: TStringField;
    Table1RANK: TFloatField;
    Table1OUTLOOK: TSmallintField;
    Table1RCMNDATION: TStringField;
    Table1RISK: TStringField;
    Table1Deleted: TStringField;
    DBText1: TDBText;
    Button1: TButton;
    procedure CheckBox1Click(Sender: TObject);
    procedure Table1CalcFields(DataSet: TDataSet);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  if CheckBox1.Checked then
    DbiSetProp(hDbiObj(Table1.Handle),curSOFTDELETEON,1)
  else
    DbiSetProp(hDbiObj(Table1.Handle),curSOFTDELETEON,0);
  Table1.Refresh;
end;

procedure TForm1.Table1CalcFields(DataSet: TDataSet);
var
  RProps : RecProps;
begin
  DbiGetRecord(Table1.Handle,dbiNOLOCK,nil,@RProps);
  if RProps.bDeleteFlag then
    Table1Deleted.Value := 'Del'
  else
    Table1Deleted.Value := '';
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  Table : TTable;
  RProps : RecProps;
begin
  Table := TTable.Create(Self);
  with Table do begin
    DatabaseName := Table1.DatabaseName;
    TableName := Table1.TableName;
    Open;
    DbiSetProp(hDbiObj(Handle),curSOFTDELETEON,1);
    Refresh;
    First;
    While not Eof do begin
      DbiGetRecord(Handle,dbiNOLOCK,nil,@RProps);
      if RProps.bDeleteFlag then
        Check(DBIUndeleteRecord(Handle));
      Next;
    end;
    Close;
    Free;
  end;
end;

end.
